#include "interface.h"

// Initialise la SDL
void initialiser_affichage(SDL_Surface** fenetre,long largeur,long hauteur,long plein_ecran)
{
    char str[255];
    long mask=SDL_HWSURFACE;

    if (plein_ecran)
    {
        mask|=SDL_FULLSCREEN;
    }

    // On initialise la SDL
    if ( SDL_Init( SDL_INIT_VIDEO ) < 0 ) // Mode Video seulement pour le moment
    {
        printf( "Impossible d'initialiser la SDL: %s\n", SDL_GetError() );
        exit(EXIT_FAILURE);
    }

    // On initialise SDL_ttf
    if(TTF_Init() == -1)
    {
        printf("Erreur d'initialisation de TTF_Init : %s\n", TTF_GetError());
        exit(EXIT_FAILURE);
    }

    putenv("SDL_VIDEO_WINDOW_POS=center"); //pour centrer la fentre
    sprintf(str,"%s%s",RESSOURCES_DIR,"icon.png");
    SDL_WM_SetIcon(IMG_Load(str),NULL);

    // On cre la fenetre
    *fenetre = SDL_SetVideoMode(largeur,hauteur, BITSPERPIXEL,mask);
    if (!*fenetre )
    {
        printf("Impossible d'afficher en %ldx%ld: %s\n",largeur,hauteur, SDL_GetError());
        exit(EXIT_FAILURE);
    }
    SDL_WM_SetCaption(TITRE, NULL); //On donne un titre  la fentre
    SDL_EnableUNICODE(1); // On active la saisie Unicode
    SDL_EnableKeyRepeat(250, 100); // On active la rptition des touches dlai 250ms, rptition 100ms
    SDL_ShowCursor(0);

    if (Mix_OpenAudio(48000, AUDIO_S16SYS, 2, 1024) < 0)
    {
        printf("Error initializing SDL_mixer: %s\n", Mix_GetError());
        exit(1);
    }

}

// Initialise l'interface et les elements du GUI
void initialiser_interface(t_interface* interface,t_partie* jeu) //Petit commentaire gnral : strlen("abc") renvoie 3... donc il faut 3 '+ 1' octets pour stocker cette chane !!
{
    long n; // compteur
    SDL_Rect coord;
    char str[255];
    str[0]=0;

    // Font charge au moment de l'initialisation du jeu...

    interface->gui_taille=23; // Nombre d'elements dans l'interface
    interface->gui=(t_gui_element**)malloc(interface->gui_taille*sizeof(t_gui_element*)); // On alloue la mmoire de ces lements
    interface->gui_actif = NULL;
    for (n=0;n<interface->gui_taille;n++)
    {
        interface->gui[n]=(t_gui_element*)malloc(sizeof(t_gui_element)); // On alloue les lements
    }

/*
    L'ECRAN qui contient la MAP
*/

/// ELEMENT 0 :  L'cran
    interface->gui[0]->type=IMAGE; // Element de type Image
    interface->gui[0]->image= SDL_CreateRGBSurface(SDL_HWSURFACE,interface->fenetre->h+8,interface->fenetre->h,32, 0,0,0,0); // On cre la surface d'affichage de la map
    interface->gui[0]->valeur=NULL;// Pas de Texte
    interface->gui[0]->position.x=0; // On Positionne la barre a cot de l'cran
    interface->gui[0]->position.y=0;// En haut
    interface->gui[0]->crop.w=interface->fenetre->h;  // Largeur de l'cran (en pixels)
    interface->gui[0]->crop.h=interface->fenetre->h;  // Hauteur de l'cran (en pixels)

    interface->gui[0]->crop.x=TILE_TAILLE*jeu->joueurs[jeu->joueur].camp_x - interface->gui[0]->crop.w/2; // Position de dpart de l'cran selon X dans la map (en pixels)
    interface->gui[0]->crop.y=TILE_TAILLE*jeu->joueurs[jeu->joueur].camp_y - interface->gui[0]->crop.h/2;  // Position de dpart de l'cran selon Y dans la map (en pixels)
    interface->gui[0]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[0]->visible=1; // Visible
    interface->gui[0]->groupe=FENETRE; // Appartient  la Fenetre
    interface->gui[0]->flag=ECRAN; // Pas d'action
    interface->gui[0]->free=FREE_IMAGE; // L'image sera libr  la fin

/*
    DESIGN DE LA BARRE LATERALE
*/

n=1; /// ELEMENT 1 :  Arrire-Plan de la Barre Latrale
    interface->gui[n]->type=IMAGE; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"barre.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image de la barre
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w; // On Positionne la barre a cot de l'cran
    interface->gui[n]->position.y=0;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 2 : Minimap
    interface->gui[n]->type=MAP; // Element de type Map
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA,160,160,BITSPERPIXEL, 0,0,0,0);// On cre la surface de la Minimap
    SDL_SetColorKey(interface->gui[n]->image, SDL_SRCCOLORKEY, SDL_MapRGB(interface->fenetre->format, 0, 0, 0)); // Le noir sera transparent
    //SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 200);
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // On place la minimap  20 pixel du bord gauche de la barre latrale,
    interface->gui[n]->position.y=420; // Et  420 pixel du bord haut, dans le trou qui lui est reserv
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=interface->gui[n]->image->w; // On ne rogne pas l'image
    interface->gui[n]->crop.h=interface->gui[n]->image->h; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=MINIMAP; // Action d'une minimap: doit permettre de se deplacer dans le monde
    interface->gui[n]->free=FREE_IMAGE; // L'image sera liber via le pointeur interface->minimap, donc rien  liberer ici

n++; /// ELEMENT 3 : Curseur Minimap

    coord=obtenir_curseur_minimap(interface,&jeu->map);

    interface->gui[n]->type=IMAGE; // Element de type Map
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,coord.w,coord.h,BITSPERPIXEL, 0,0,0,0);// On cre la surface de la Minimap
    SDL_SetColorKey(interface->gui[n]->image, SDL_SRCCOLORKEY, SDL_MapRGB(interface->fenetre->format, 0, 0, 0)); // Le noir sera transparent
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc

    coord.x=1;
    coord.y=1;
    coord.w= interface->gui[n]->image->w - 2;
    coord.h= interface->gui[n]->image->h - 2;

    SDL_FillRect(interface->gui[n]->image, &coord, SDL_MapRGB(interface->fenetre->format, 0, 0, 0)); // On remplit le champ en blanc
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // On place la minimap  20 pixel du bord gauche de la barre latrale,
    interface->gui[n]->position.y=420; // Et  420 pixel du bord haut, dans le trou qui lui est reserv
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=MINIMAP_CURSEUR; // Action d'une minimap: doit permettre de se deplacer dans le monde
    interface->gui[n]->free=FREE_IMAGE; // On libre l'image du curseur

n++; /// ELEMENT 4 : Texte "A la Recherche du Graal"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen(" la recherche du Graal") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur," la recherche du Graal"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // On le positionne  50px du bord gauche de la barre,
    interface->gui[n]->position.y=72; // et  72 px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber

n++;  /// ELEMENT 5 : Trou / Cadre pour le joueur qui joue
    interface->gui[n]->type=IMAGE; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"cadre.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+52; // Positionnement  5 px du bord gauche
    interface->gui[n]->position.y=96; // et 200px du bord haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=interface->gui[n]->image->w; // On ne rogne pas l'image
    interface->gui[n]->crop.h=interface->gui[n]->image->h; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libre

n++;  /// ELEMENT 11 : Image / Aperu du Joueur qui joue
    // On dfinit l'image du tile courant
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=jeu->joueurs[0].avatar; // Pas d'allocation, on pointe diretement sur le pointeur de la surface du Tileset
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+68;  // Position en X de l'image (au centre du cadre)
    interface->gui[n]->position.y=112;  // Position en Y de l'image (au centre du cadre)
    interface->gui[n]->crop.x=0; // Tile n0
    interface->gui[n]->crop.y=0; // Tile n0
    interface->gui[n]->crop.w=64; // Largeur d'une Tile
    interface->gui[n]->crop.h=64; // Hauteur d'une Tile
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=JOUEUR_APERCU; // Action: l'image doit correspondre  la tile actuelle
    interface->gui[n]->free=FREE_RIEN; // On ne libre rien ici

n++;  /// ELEMENT 11 : Nom du Joueur qui joue
    // On dfinit le texte du joueur
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'allocation
    interface->gui[n]->valeur=(char *)malloc(32);// Pas de Texte
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=interface->gui[0]->crop.w+24;  // Position en X de l'image (au centre du cadre)
    interface->gui[n]->position.y=184;  // Position en Y de l'image (au centre du cadre)
    interface->gui[n]->crop.x=0; // Pas Crop
    interface->gui[n]->crop.y=0; // Pas Crop
    interface->gui[n]->crop.w=0; // Pas Crop
    interface->gui[n]->crop.h=0; // Pas Crop
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=JOUEUR_NOM; // Action: le texte doit correspondre au nom du joueur
    interface->gui[n]->free=FREE_RIEN; // On ne libre rien ici

n++;  /// ELEMENT 5 : Trou / Cadre pour le personnage selectionn
    interface->gui[n]->type=IMAGE; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"cadre.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w; // Positionnement  5 px du bord gauche
    interface->gui[n]->position.y=232; // et 200px du bord haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=interface->gui[n]->image->w; // On ne rogne pas l'image
    interface->gui[n]->crop.h=interface->gui[n]->image->h; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libre

n++;  /// ELEMENT 11 : Image / Aperu de la Tile courante
    // On dfinit l'image du tile courant
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=jeu->map.fx.image; // Pas d'allocation, on pointe diretement sur le pointeur de la surface du Tileset
    SDL_SetColorKey(interface->gui[n]->image, SDL_SRCCOLORKEY, SDL_MapRGB(interface->fenetre->format, 255, 0, 255)); // Le noir sera transparent
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+30;  // Position en X de l'image (au centre du cadre)
    interface->gui[n]->position.y=264;  // Position en Y de l'image (au centre du cadre)
    interface->gui[n]->crop.x=128; // Tile n0
    interface->gui[n]->crop.y=0; // Tile n0
    interface->gui[n]->crop.w=TILE_TAILLE; // Largeur d'une Tile
    interface->gui[n]->crop.h=TILE_TAILLE; // Hauteur d'une Tile
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=PIONACTUEL_APERCU; // Action: l'image doit correspondre  la tile actuelle
    interface->gui[n]->free=FREE_RIEN; // On ne libre rien ici

n++;  /// ELEMENT 5 : Dcor de la progress bar
    interface->gui[n]->type=IMAGE; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"progress.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image de la barre
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w + 84; // Positionnement  5 px du bord gauche
    interface->gui[n]->position.y=288; // et 200px du bord haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=interface->gui[n]->image->w; // On ne rogne pas l'image
    interface->gui[n]->crop.h=interface->gui[n]->image->h; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=FOND_PTS; // On prcise que c'est le fond de la progress bar des pts de mouvement
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libre

n++;  /// ELEMENT 5 : Progress bar pour les Points de Mouvement
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA , 64, 6, BITSPERPIXEL, 0,0,0,0);// On charge l'image du trou
    SDL_FillRect(interface->gui[n]->image, NULL, SDL_MapRGBA(interface->gui[n]->image->format, 255, 0, 0,255));
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w + 100; // Positionnement  5 px du bord gauche
    interface->gui[n]->position.y=301; // et 200px du bord haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=interface->gui[n]->image->w; // On ne rogne pas l'image
    interface->gui[n]->crop.h=interface->gui[n]->image->h; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=PIONACTUEL_PTS; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libre

n++;  /// ELEMENT 5 : Progress bar pour les Points de Mouvement
    interface->gui[n]->type=TEXTE; // Element de type Image
    interface->gui[n]->image=NULL;// On charge l'image du trou
    interface->gui[n]->valeur=(char *)malloc(32);// Pas de Texte
    sprintf(interface->gui[n]->valeur,"? / ?");
    interface->gui[n]->position.x=interface->gui[0]->crop.w + 100; // Positionnement  5 px du bord gauche
    interface->gui[n]->position.y=274; // et 200px du bord haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=PIONACTUEL_PTS; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // L'image sera libre

n++;  /// ELEMENT 11 : Nom du Pion
    // On le nom du pion selectionn
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'allocation
    interface->gui[n]->valeur=(char *)malloc(32);// 32 caractre pour le type de pion, c'est largemetn suffisant
    interface->gui[n]->valeur[0]=0;// On initialise
    interface->gui[n]->position.x=interface->gui[0]->crop.w+96;  // Position en X de l'image (au centre du cadre)
    interface->gui[n]->position.y=244;  // Position en Y du texte
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=PIONACTUEL_NOM; // Action: le texte doit correspondre au nom du pion
    interface->gui[n]->free=FREE_VALEUR; // On ne libre rien ici

n++;  /// ELEMENT 11 : Prochain dplacement
    // On le nom du pion selectionn
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'allocation
    interface->gui[n]->valeur=(char *)malloc(32);// 32 caractre pour le type de pion, c'est largemetn suffisant
    interface->gui[n]->valeur[0]=0;// On initialise
    interface->gui[n]->position.x=interface->gui[0]->crop.w+12;  // Position en X de l'image (au centre du cadre)
    interface->gui[n]->position.y=320;  // Position en Y du texte
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=PIONACTUEL_MVT; // Action: le texte doit correspondre au nom du pion
    interface->gui[n]->free=FREE_VALEUR; // On ne libre rien ici

n++; /// ELEMENT 18 : Bouton Fin du tour
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(strlen("Finir le Tour") + 1); // On alloue la mmoire pour le texte du bouton
    sprintf(interface->gui[n]->valeur,"Finir le Tour"); // On inscrit le texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // Position en X du bouton
    interface->gui[n]->position.y=208; // Position en Y du bouton
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=FINIR; // Action: Sauvegarder la map
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 17: Saisie du nom de la sauvegarde
    interface->gui[n]->type=SAISIE; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX + 1); // On alloue la mmoire pour le texte du bouton
    sprintf(interface->gui[n]->valeur,"sauvegarde.kjeu"); // On inscrit le texte dans l'element
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA , 160, 24, BITSPERPIXEL, 0,0,0,0);// On charge l'image du bouton
    SDL_FillRect(interface->gui[n]->image, NULL, SDL_MapRGB(interface->gui[n]->image->format, 255, 255,255));
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // Position en X du bouton
    interface->gui[n]->position.y=354; // Position en Y du bouton
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=24;// Hauteur 32 px
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=SAUVEGARDE_NOM; // Action: Sauvegarder la map
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 18 : Bouton Sauvegarder la map
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(strlen("Sauvegarder") + 1); // On alloue la mmoire pour le texte du bouton
    sprintf(interface->gui[n]->valeur,"Sauvegarder"); // On inscrit le texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image du bouton
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // Position en X du bouton
    interface->gui[n]->position.y=380; // Position en Y du bouton
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=SAUVEGARDER; // Action: Sauvegarder la map
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 24 : Fond de la Fenetre de Chat
    interface->gui[n]->type=IMAGE; // Element de type Bouton
    interface->gui[n]->valeur=NULL; // On alloue la mmoire pour le texte du bouton
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA , 536, 192, BITSPERPIXEL, RMASK, GMASK, BMASK, AMASK);
    SDL_FillRect(interface->gui[n]->image, NULL, SDL_MapRGBA(interface->gui[n]->image->format, 0, 0, 0,128));
    //SDL_SetAlpha( front, SDL_SRCALPHA | SDL_RLEACCEL, alpha );
    //SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    interface->gui[n]->position.x=32; // Position en X du bouton (Hrite)
    interface->gui[n]->position.y=376;// Position en Y du bouton (Hrite)
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=536; // largeur 160px
    interface->gui[n]->crop.h=192;// Hauteur 32 px
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=POPUP_CHAT; // Appartient au menu droulant du Type
    interface->gui[n]->flag=AUCUN;// Action: Parametrer le type du terrain  MORTEL
    interface->gui[n]->free=FREE_IMAGE; // On libre l'image

n++; /// ELEMENT 25 : Fenetre du Chat
    interface->gui[n]->type=IMAGE; // Element de type Bouton
    interface->gui[n]->valeur=(char *)malloc(32); // On alloue la mmoire pour le texte du bouton
    sprintf(interface->gui[n]->valeur,"%ld",(long)-5000);

    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA , 528, 192, BITSPERPIXEL, RMASK, GMASK, BMASK, AMASK);
    SDL_FillRect(interface->gui[n]->image, NULL, SDL_MapRGBA(interface->gui[n]->image->format, 0,0,0,0));
    //SDL_SetAlpha( front, SDL_SRCALPHA | SDL_RLEACCEL, alpha );
    //SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    interface->gui[n]->position.x=36; // Position en X du bouton (Hrite)
    interface->gui[n]->position.y=376;// Position en Y du bouton (Hrite)
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=528; // largeur 160px
    interface->gui[n]->crop.h=192;// Hauteur 32 px
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=POPUP_CHAT; // Appartient au menu droulant du Type
    interface->gui[n]->flag=MESSAGES;// Action: Contient les messages du programme
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image

n++; /// ELEMENT 7 :  Saisie du Nom de la Map
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,536,24,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX+1); // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=36; // Position en X du champ
    interface->gui[n]->position.y=interface->gui[0]->crop.h-28; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=536; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=CMD; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On ne libre pas le texte, parce qu'il appartient  la map !!!

n++; /// ELEMENT 26 : FPS
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("fps: XX") + 1); // On alloue la mmoire pour le texte
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=2; // Position en X du texte
    interface->gui[n]->position.y=2; // Position en Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=FENETRE; // Appartient au menu droulant du Type
    interface->gui[n]->flag=FPS; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // On libre le texte allou

n++; /// ELEMENT 26 : FPS
    interface->gui[n]->type=IMAGE; // Element de type Texte
    sprintf(str,"%s%s",RESSOURCES_DIR,"curseur.png"); // On rcupre le chemin du curseur
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    interface->gui[n]->valeur=NULL; // On alloue la mmoire pour le texte
    interface->gui[n]->position.x=0; // Position en X du texte
    interface->gui[n]->position.y=0; // Position en Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=24; // Pas de crop
    interface->gui[n]->crop.h=24; // Pas de crop
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=FENETRE; // Appartient au menu droulant du Type
    interface->gui[n]->flag=POINTEUR; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // On libre le texte allou

    interface->pointeur.x = 0;
    interface->pointeur.y = 0;

    Mix_VolumeMusic(interface->options.volume_musique);

    sprintf(str,"%s%s",SOUNDS_DIR,"ambiance.ogg");
    interface->musique=Mix_LoadMUS(str);

    if(!interface->musique) {
        printf("Mix_LoadMUS(\"%s\"): %s\n",str, Mix_GetError());
        // this might be a critical error...
    }


}

// Supprime les donnes de l'interface
void liberer_interface(t_interface* interface) //dite le 25/02/2010  14:11 par Loc
{
    long n; // Compteur

    TTF_CloseFont(interface->font);// On supprime la police de caractre

    for (n=0;n<interface->gui_taille;n++) // Pour chaque element du GUI
    {
        if (interface->gui[n]->free & FREE_IMAGE) // Si on doit supprimer l'image
        {
            SDL_FreeSurface(interface->gui[n]->image); // On supprime l'image
        }

        if (interface->gui[n]->free & FREE_VALEUR)// Si on doit supprimer le texte
        {
            free(interface->gui[n]->valeur);  // On libre le texte
        }

        free(interface->gui[n]); // On libre ensuite l'element
    }
    Mix_FreeMusic(interface->musique);
    free(interface->gui); // On supprime enfin les pointeurs vers ces elements

    // la variable interface sera libr  la fin du main automatiquement
}

void liberer_affichage(SDL_Surface* fenetre)
{
    SDL_FreeSurface(fenetre);// On supprime la surface de la fenetre

    TTF_Quit(); // On quitte SDL_ttf
    SDL_Quit(); // On quitte la SDL
}

// Affiche l'interface
void afficher_interface(t_interface* interface,t_partie* jeu)
{

    long n; // Compteur
    SDL_Rect position, crop; // Structures utilises pour le positionnement et le rognage
    SDL_Color couleur; //Contient la couleur du texte  afficher
    SDL_Surface * tmpsurface = NULL; // Surface temporaire
    char str[256]; // Chaine de caractre pour les champ de saisie
    for (n=0;n<interface->gui_taille;n++)
    {
        actualiser_gui(n, interface,jeu);// On actualise l'element courant en fonction de son flag, ainsi que les donnes qu'il concerne
    }

    for (n=0;n<interface->gui_taille;n++)
    {
        str[0]=0; // On efface la chaine de caractre
        // On paramtre la couleur du texte  NOIR
        couleur.r=0;
        couleur.g=0;
        couleur.b=0;

        if (interface->gui[n]->visible) // Si l'element est visible, on l'affiche
        {
            if (interface->gui[n]->type == TEXTE) // Si l'element est de type Texte
            {
                tmpsurface = TTF_RenderText_Blended(interface->font, interface->gui[n]->valeur, couleur); // On place le texte dans la surface temporaire
                SDL_BlitSurface(tmpsurface, 0, interface->fenetre, &interface->gui[n]->position); // On blitte le texte
                SDL_FreeSurface(tmpsurface); // On dtruit la surface temporaire pour une utilisation ultrieure
                /*
                Remarque: On pourrait utiliser le champ image pour la surface au lieu de tmpsurface, mais on pourrait imaginer ke le texte
                aurait un arrire plan color
                */
            }
            else if (interface->gui[n]->type == SAISIE)  // Si l'element est de type Saisie
            {

                sprintf(str,"%s   ",interface->gui[n]->valeur); // On place dans la chaine de caractre temporaire la valeur du champ

                if (interface->gui[n]->etat == ACTIF) // Si l'element est actif (selectionn)
                {
                    if((SDL_GetTicks()/500)%2) // Toutes les demi-secondes
                    {
                            sprintf(str,"%s|",interface->gui[n]->valeur); // On remplace la chaine de caractre pour y rajouter un curseur
                    }
                }

                tmpsurface = TTF_RenderText_Blended(interface->font, str , couleur);// On place le texte dans la surface temporaire


                position.x = interface->gui[n]->position.x + 2; // On laisse un marge de 2px  gauche
                position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2); // On centre verticalement le texte dans le champ
                crop=interface->gui[n]->crop; // on rogne le texte  la taille du champ pour eviter qu'il dpasse

                if ((tmpsurface->w+2) > interface->gui[n]->crop.w) // Si le texte est plus large que le champ
                {
                    crop.x=tmpsurface->w-interface->gui[n]->crop.w+2; // On l'aligne sur la droite et non sur la gauche avec une marge de 2 px
                }


                SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On affiche le fond du champ
                SDL_BlitSurface(tmpsurface, &crop , interface->fenetre, &position);// Puis le texte (rogn) par dessus
                SDL_FreeSurface(tmpsurface); // On n'noublie pas de librer la mmoire de la surface temporaire
            }
            else if (interface->gui[n]->type == BOUTON || interface->gui[n]->type == SWITCH) // Si l'element est un bouton (switchable ou non)
            {
                if (interface->gui[n]->valeur) // si le bouton contient un texte
                {
                    tmpsurface = TTF_RenderText_Blended(interface->font, interface->gui[n]->valeur , couleur); // On place le texte dans la surface temporaire

                    if (interface->gui[n]->type == SWITCH) // Si l'element est un switch
                    {
                        // Alignement sur la gauche
                        position.x = interface->gui[n]->position.x + 16; // On garde une marge  gauche de 16px
                        position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2); // On centre verticalement le texte dans le champ
                    }
                    else // Sinon
                    {
                        // Alignement centr
                        position.x = interface->gui[n]->position.x + ((interface->gui[n]->crop.w - tmpsurface->w)/2);// On centre horizontalement le texte dans le champ
                        position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2);// On centre verticalement le texte dans le champ
                    }
                }

                if (interface->gui[n]->etat == ACTIF) // Si le bouton est actif (enfonc)
                {
                    interface->gui[n]->crop.y=2*interface->gui[n]->crop.h; // On prend la 3eme position dans l'image (Enfonce)
                    // On dplace le texte en diagonale (effet d'enfoncement)
                    position.x+=2; // 2 pixels vers la droite
                    position.y+=2; // 2 pixels vers le bas
                }
                else if (interface->gui[n]->etat == SURVOL) // Sinon si il est juste survol
                {
                    interface->gui[n]->crop.y=interface->gui[n]->crop.h; // On prend la 2eme position dans l'image (Highlighted - Eclaire)
                }
                else // Sinon
                {
                    interface->gui[n]->crop.y=0; // On prend la 1ere position dans l'image (Normale)
                }

                SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On affiche le bouton

                if (interface->gui[n]->valeur) // Toujours si ya un texte
                {
                    SDL_BlitSurface(tmpsurface, 0, interface->fenetre, &position); // On affiche le texte par dessus
                    SDL_FreeSurface(tmpsurface); // On n'noublie pas de librer la mmoire de la surface temporaire
                }
            }
            else if (interface->gui[n]->type == IMAGE) // SI l'element est juste une image
            {
                if (interface->gui[n]->crop.h && interface->gui[n]->crop.w && interface->gui[n]->flag != ECRAN) // Si l'on doit la rogner
                {
                    SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On l'affiche rogne
                }
                else // Sinon
                {
                    SDL_BlitSurface(interface->gui[n]->image, 0, interface->fenetre, &interface->gui[n]->position); // On l'affiche entire
                }
            }
            else if (interface->gui[n]->type == MAP) // Si l'element est de type map
            {
                SDL_BlitSurface(interface->gui[n]->image, 0, interface->fenetre, &interface->gui[n]->position); // On affiche la map comme une image...
            }
        }
    }
}

// Actualise les elements et les donnes avant affichage
void actualiser_gui(long element,t_interface* interface,t_partie* jeu)
{
    long n;
    SDL_Rect coord;
    SDL_Color couleur;
    long chat_dernier_temps;
    char str[255];
    str[0]=0;

    /*
    Remarque: Le switch est ger diffrement que le reste des elements dans la boucle d'evenements, car c'est un bouton ON/OFF,
    il peut tre actif meme si un autre element est selectionn, un clic inverse donc l'activation de ce type d'element
    */
    if (interface->gui[element]->type!=SWITCH)// Si l'element n'est donc pas un switch
    {
        if (interface->gui[element] == interface->gui_actif) // Si l'element est selectionn
        {
            interface->gui[element]->etat=ACTIF; // Alors il est actif
        }
        else if (interface->pointeur.x>=interface->gui[element]->position.x
        && interface->pointeur.x < interface->gui[element]->position.x+interface->gui[element]->crop.w
        && interface->pointeur.y>=interface->gui[element]->position.y
        && interface->pointeur.y < interface->gui[element]->position.y+interface->gui[element]->crop.h
        ) // Si le pointeur est situ entre son coin haut gauche et son coin bas droit
        {
            interface->gui[element]->etat=SURVOL; // Alors il est survol
        }
        else // Sinon
        {
            interface->gui[element]->etat=INACTIF; // Il est inactif
        }
    }
    else // Sinon, si l'element est un switch
    {
        if (interface->gui[element]->etat!=ACTIF) // ET qu'il n'est pas actif, cd, sur la position OFF
        {
            if (interface->pointeur.x>=interface->gui[element]->position.x
            && interface->pointeur.x < interface->gui[element]->position.x+interface->gui[element]->crop.w
            && interface->pointeur.y>=interface->gui[element]->position.y
            && interface->pointeur.y < interface->gui[element]->position.y+interface->gui[element]->crop.h
            ) // Si le pointeur est situ entre son coin haut gauche et son coin bas droit
            {
                interface->gui[element]->etat=SURVOL; // ALors il est survol
            }
            else
            {
                interface->gui[element]->etat=INACTIF; // Sinon, il est juste en position OFF
            }
        }
    }

    /* Remarque:
    Le flag determine comment reagit un element, les donnes qu'il doit actualiser, ce qu'il stocke, et quel aspect
    il doit avoir en fonction des donnes qui lui sont exterieurs
    */
    switch(interface->gui[element]->flag) // On actualise diffrement un element en fonction de son flag
    {
        case ECRAN:

            afficher_map(&jeu->map,interface); // On blitte la map sur l'ecran
            afficher_pions(interface,jeu);
            break;
        case MINIMAP_CURSEUR:
            coord=obtenir_curseur_minimap(interface,&jeu->map);

            interface->gui[element]->position.x=
                interface->gui[element-1]->position.x+coord.x+ (interface->gui[0]->crop.x*(160-2*coord.x))/(jeu->map.largeur*TILE_TAILLE);

            interface->gui[element]->position.y=
                interface->gui[element-1]->position.y+coord.y+ (interface->gui[0]->crop.y*(160-2*coord.y))/(jeu->map.hauteur*TILE_TAILLE);
            break;
        case JOUEUR_APERCU:
            if (jeu->tour >0 &&jeu->tour<=jeu->nbr_joueurs)
            {
                interface->gui[element]->image=jeu->joueurs[jeu->tour].avatar;
            }
            else
            {
                interface->gui[element]->image=jeu->joueurs[0].avatar;
            }
            break;
        case JOUEUR_NOM:
            if (jeu->tour >0 &&jeu->tour<=jeu->nbr_joueurs)
            {
                sprintf(interface->gui[element]->valeur,"Au Tour de %s",jeu->joueurs[jeu->tour].pseudo);
                interface->gui[element]->visible=1;
            }
            else
            {
                interface->gui[element]->visible=0;
            }
            break;
        case PIONACTUEL_APERCU:
            if (interface->pion != -1)
            {

                interface->gui[element]->image=jeu->joueurs[jeu->pions[interface->pion].joueur].tileset[jeu->pions[interface->pion].type].image;
                interface->gui[element]->crop.x=0;
                interface->gui[element]->crop.y=0;

            }
            break;
        case PIONACTUEL_NOM:
            if (interface->pion != -1)
            {
                interface->gui[element]->visible=1;
                switch(jeu->pions[interface->pion].type)
                {
                    case GRAAL:
                        sprintf(interface->gui[element]->valeur,"Graal"); break;
                    case ECLAIREUR:
                        sprintf(interface->gui[element]->valeur,"Eclaireur"); break;
                    case PECORE:
                        sprintf(interface->gui[element]->valeur,"Pcore"); break;
                    case CHEVALIER:
                        sprintf(interface->gui[element]->valeur,"Chevalier"); break;
                }

            }
            else
            {
                interface->gui[element]->visible=0;
            }
            break;
        case PIONACTUEL_PTS:
            n=obtenir_element(interface,FOND_PTS);

            if (interface->pion != -1)
            {
                if (jeu->pions[interface->pion].pts_max > 0)
                {
                    if (interface->gui[element]->type==TEXTE)
                    {

                        interface->gui[n]->visible=1;
                        interface->gui[element]->visible=1;
                        sprintf(interface->gui[element]->valeur,"%ld / %ld",jeu->pions[interface->pion].pts,jeu->pions[interface->pion].pts_max);
                    }
                    else
                    {
                        interface->gui[n]->visible=1;
                        if (jeu->pions[interface->pion].pts>0)
                        {

                            interface->gui[element]->visible=1;
                            interface->gui[element]->crop.w=(64*jeu->pions[interface->pion].pts/jeu->pions[interface->pion].pts_max);
                        }
                        else
                        {

                             interface->gui[element]->visible=0;
                        }

                        n = (510 * jeu->pions[interface->pion].pts) / jeu->pions[interface->pion].pts_max;
                        if( n > 255)
                        {
                            couleur.r = 510 - n;
                            couleur.g = 255;
                        }
                        else
                        {
                             couleur.g = n;
                             couleur.r = 255;
                        }

                        couleur.b=0;

                        SDL_FillRect(interface->gui[element]->image, 0, SDL_MapRGB(interface->fenetre->format, couleur.r, couleur.g, couleur.b)); // On remplit le champ en blanc
                    }
                }
                else
                {
                    interface->gui[n]->visible=0;
                    interface->gui[element]->visible=0;
                }
            }
            else
            {
                interface->gui[n]->visible=0;
                interface->gui[element]->visible=0;
            }
            break;
        case PIONACTUEL_MVT:
            if (interface->pion != -1)
            {
                if (jeu->pions[interface->pion].pts_max > 0)
                {
                    interface->gui[element]->visible=1;
                    n=jeu->map.tile[jeu->map.cases[jeu->pions[interface->pion].pos_y][jeu->pions[interface->pion].pos_x].tile].cout_pts;
                    if (n==0)
                    {
                        sprintf(interface->gui[element]->valeur,"Dplacement: Tous les pts");
                    }
                    else
                    {
                        sprintf(interface->gui[element]->valeur,"Dplacement: %ldpts",n);
                    }
                }
                else
                {
                    interface->gui[element]->visible=0;
                }
            }
            else
            {
                interface->gui[element]->visible=0;
            }

            break;
        case MESSAGES:
            n=obtenir_element(interface, CMD); // On rcupre l'indice de l'element Ligne de commande

            sscanf(interface->gui[element]->valeur,"%ld",&chat_dernier_temps);
            if( SDL_GetTicks()-chat_dernier_temps > 5000 && !interface->gui[n]->visible)
            {
                afficher_groupe(interface,POPUP_CHAT,0);
            }
            else
            {
                afficher_groupe(interface,POPUP_CHAT,1);
            }

            break;
        case FPS:
            sprintf(interface->gui[element]->valeur,"fps: %ld",obtenir_fps(1));
            break;
        case POINTEUR:
            if (interface->mousefocus)
            {
                interface->gui[element]->visible=1;
                interface->gui[element]->position=interface->pointeur;
                interface->gui[element]->crop.x=interface->clic*32;
            }
            else
            {
                interface->gui[element]->visible=0;
            }
            break;
        default: // Si l'element a un flag qui ne requiert aucune actualisation spcifique
        // On ne fait rien (et on vite un avertissement du compilateur)
            break;
    }
}

 // Effectuer l'action d'un flag
void effectuer_gui(enum gui_flag flag,t_interface* interface,t_partie* jeu, t_serveur*serv)
{
    // char str[255];
    /* Remarque :
    Lorsqu'un lement est "valid", par la touche entre si c'est une saisie, ou un clic pour un bouton,
    alors on doit faire l'action correpondnate, et dsigne par le flag de l'element
    */
    long element=0,desactiver=1;
    element=obtenir_element(interface, flag);

    switch(flag)// En fonction du flag
    {
        case SWITCH_CMD:
            element=obtenir_element(interface, CMD);

            if (interface->gui[element]->visible)
            {
                interface->gui[element]->visible=0;
            }
            else
            {
                interface->gui[element]->visible=1;
                interface->gui_actif=interface->gui[element];
                desactiver=0;
            }
            break;
        case FINIR:
            communiquer(TOUR, 0, NULL, serv);
            break;
        case SAUVEGARDER:
            element=obtenir_element(interface, SAUVEGARDE_NOM);
            communiquer(SAUVEGARDE, strlen(interface->gui[element]->valeur) + 1, interface->gui[element]->valeur, serv); //Demande une sauvegarde au serveur
            break;
        case CMD:
            if(strcmp("moonwalk", interface->gui[element]->valeur)==0)
            {
                interface->options.moonwalk=!interface->options.moonwalk;
                //Traitement commande
                afficher_message(interface, interface->gui[element]->valeur, 128,0,255);
            }
            else if(strcmp("elleestoulapoulette", interface->gui[element]->valeur)==0)
            {
                interface->options.poulette=!interface->options.poulette;
                //Traitement commande2
                afficher_message(interface, interface->gui[element]->valeur, 128,0,255);
                actualiser_minimap(jeu,interface);
            }
            else {envoyer_message(interface->gui[element]->valeur, serv);} //Sinon le joueur chat
            interface->gui[element]->valeur[0]=0;
            break;
        default:
            break;
    }

    if (desactiver)
    {
        interface->gui_actif=0; // On dsactive ensuite l'element valid (ou l'element actuellement activ)
    }
}

// Scrolle l'ecran en fonction du curseur / Touche enfonce
void scroller_ecran(t_interface* interface,t_map* map)
{
    int scroll =0;// Teste si le pointeur est dans uen zone de scroll, sinon rinitialise le compteur du dlai
    static Uint32 scroll_temps=0; // Enregistre le dernier temps avant scroll (conserv pour un appel futur)
    Uint32 temps; // Contient le temps actuel
    temps = SDL_GetTicks(); // On rcpere le temps actuel
    long minimap_element=0,minimap_curseur=0, cmd_element=0;;
    SDL_Rect coord;
    minimap_element=obtenir_element(interface, MINIMAP);
    minimap_curseur=obtenir_element(interface, MINIMAP_CURSEUR);
    cmd_element=obtenir_element(interface, CMD);

    switch(interface->touche) // On vrifie la touche enfonce
    {
        case SDLK_UP: // Flche haut
            interface->gui[0]->crop.y-=32; // On scrolle vers le haut
            break;
        case SDLK_DOWN: // Flche bas
            interface->gui[0]->crop.y+=32; // On scrolle vers le bas
            break;
        case SDLK_RIGHT: // Flche droite
            interface->gui[0]->crop.x+=32; // On scroll vers la droite
            break;
        case SDLK_LEFT: // Flche gauche
            interface->gui[0]->crop.x-=32; // ON scroll vers la gache
            break;
        default: // Si la touche enfonce n'est pas une flche (ou si rien n'est enfonce)
            scroll = 0; // On initialise le test  nul
            if (interface->mousefocus)
            {
                // Si le pointeur se situe sur le bord droit de l'cran
                if (interface->pointeur.x>=(interface->gui[0]->crop.w-SCROLL_BORDURE) && interface->pointeur.x<(interface->gui[0]->crop.w))
                {
                    if(temps - scroll_temps > 200) // Le temps coul doit etre d'au moisn 200ms
                    {
                        interface->gui[0]->crop.x+=16; // Scrolle vers la droite
                    }
                    scroll = 1; // On est dans une zone de scroll
                }

                // Si le pointeur se situe sur le bord gauche de l'cran
                if (interface->pointeur.x>=0 && interface->pointeur.x<SCROLL_BORDURE)
                {
                    if(temps - scroll_temps > 200) // Le temps coul doit etre d'au moisn 200ms
                    {
                        interface->gui[0]->crop.x-=16; // Scrolle vers la gauche
                    }
                    scroll = 1; // On est dans une zone de scroll
                }

                if (!interface->gui[cmd_element]->visible) // On dsactive le scroll vers le bas si la saisie de la ligne de commande est visible
                {
                    // Si le pointeur se situe sur le bord bas de l'ecran (et pas sur la barre latrale)
                    if (interface->pointeur.y>=(interface->gui[0]->crop.h-SCROLL_BORDURE) && interface->pointeur.y<(interface->gui[0]->crop.h)&& interface->pointeur.x<interface->gui[0]->crop.w)
                    {
                        if(temps - scroll_temps > 200) // Le temps coul doit etre d'au moisn 200ms
                        {
                            interface->gui[0]->crop.y+=16; // Scrolle vers le bas
                        }
                        scroll = 1; // On est dans une zone de scroll
                    }
                }
                // Si le pointeur se situe sur le bord haut de l'ecran (et pas sur la barre latrale)
                if (interface->pointeur.y>=0 && interface->pointeur.y<SCROLL_BORDURE && interface->pointeur.x<interface->gui[0]->crop.w)
                {
                    if(temps - scroll_temps > 200) // Le temps coul doit etre d'au moisn 200ms
                    {
                        interface->gui[0]->crop.y-=16; // Scrolle vers le haut
                    }
                    scroll = 1; // On est dans une zone de scroll
                }
            }
            if (!scroll) // Si on n'est pas dans une zone de scroll
            {
                scroll_temps=temps; // On met le dernier temps avant scroll au temps actuel
            }

            if (interface->clic && minimap_element != -1 && minimap_curseur != -1 )
            {
                if (    interface->pointeur.x>=interface->gui[minimap_element]->position.x
                    &&  interface->pointeur.x<interface->gui[minimap_element]->position.x+160
                    &&  interface->pointeur.y>=interface->gui[minimap_element]->position.y
                    &&  interface->pointeur.y<interface->gui[minimap_element]->position.y+160
                   )
                {
                    coord=obtenir_curseur_minimap(interface,map);

                    interface->gui[0]->crop.x=((interface->pointeur.x-coord.x-(interface->gui[minimap_element]->position.x-1))*map->largeur*TILE_TAILLE)/(160-2*coord.x);
                    interface->gui[0]->crop.y=((interface->pointeur.y-coord.y-(interface->gui[minimap_element]->position.y-1))*map->hauteur*TILE_TAILLE)/(160-2*coord.y);
                }
            }
            break;
    }

    // Si apres scroll l'cran sort de la map  droite
    if (interface->gui[0]->crop.x>(map->largeur*TILE_TAILLE - (interface->gui[0]->crop.w+8)))
    {interface->gui[0]->crop.x=(map->largeur*TILE_TAILLE - (interface->gui[0]->crop.w+8));} // On limite l'ecran au bord droit
    // Si apres scroll l'cran sort de la map en bas
    if (interface->gui[0]->crop.y>(map->hauteur*TILE_TAILLE - interface->gui[0]->crop.h))
    {interface->gui[0]->crop.y=(map->hauteur*TILE_TAILLE - interface->gui[0]->crop.h);} // On limite l'ecran au bord bas
    // Si apres scroll l'cran sort de la map  gauche
    if (interface->gui[0]->crop.x<0){interface->gui[0]->crop.x=0;} // On limite l'ecran au bord gauche
    // Si apres scroll l'cran sort de la map en haut
    if (interface->gui[0]->crop.y<0){interface->gui[0]->crop.y=0;} // On limite l'ecran au bord haut
}

long obtenir_element(t_interface *interface,enum gui_flag flag)
{
    long n,element=-1;

    for (n=0; n<interface->gui_taille;n++)
    {
        if (interface->gui[n]->flag==flag)
        {
            element=n;
        }
    }
    return element;
}

// Affiche / Masque un groupe d'elements en fonction de visible
void afficher_groupe(t_interface *interface, enum gui_groupe groupe, long visible)
{
    long n;

    for (n=0; n<interface->gui_taille;n++)
    {
        if (interface->gui[n]->groupe==groupe)
        {
            interface->gui[n]->visible=visible;
        }
    }
}

void afficher_message(t_interface *interface, char *txt, long rouge, long vert, long bleu)
{
    long chat_element;
    SDL_Surface* mess;

    chat_element=obtenir_element(interface,MESSAGES);


    if (chat_element!=-1)
    {

        mess=interface->gui[chat_element]->image;

        SDL_Surface *texte; //Contient le texte sous forme d'image  copier sur la destination (resul)
        SDL_Rect position; //Contient les paramtres de position pour les diffrents affichages  effectuer
        SDL_Color couleur; //Contient la couleur du texte  afficher

        //Convertit le texte en une image  coller sur ecran
        couleur.r = rouge;
        couleur.g = vert;
        couleur.b = bleu;
        texte = TTF_RenderText_Blended(interface->font, txt, couleur); //crit le texte
        //Scroll
        interface->gui[chat_element]->image = SDL_CreateRGBSurface(mess->flags, mess->w, mess->h, mess->format->BitsPerPixel, mess->format->Rmask, mess->format->Gmask, mess->format->Bmask, mess->format->Amask);
        SDL_FillRect(interface->gui[chat_element]->image, NULL, SDL_MapRGBA(mess->format, 0, 0, 0, 0));
        SDL_SetAlpha(mess, 0,255); // On desactive le SRCALPHA pour copier les donnes RGBA, et remplacer l'alpha de la destination
        SDL_SetAlpha(texte, 0,255); // On desactive le SRCALPHA pour copier les donnes RGBA, et remplacer l'alpha de la destination

        position.x = 0;
        position.y = texte->h;
        position.w = mess->w;
        position.h = mess->h - texte->h;
        SDL_BlitSurface(mess, &position, interface->gui[chat_element]->image, NULL);
        //Affichage du nouveau texte
        position.x = 0;
        position.y = mess->h - texte->h;
        SDL_BlitSurface(texte, NULL, interface->gui[chat_element]->image, &position);
        //On efface l'image du texte
        SDL_FreeSurface(texte);
        SDL_FreeSurface(mess);

        sprintf(interface->gui[chat_element]->valeur,"%ld",(long)SDL_GetTicks());
    }
}

long obtenir_fps(long incrementer)
{
    static long dernier_f=0,frames=0,dernier_temps=0;

    if (dernier_temps-SDL_GetTicks()>= 1000)
    {
        dernier_f=frames;
        frames=0;
        dernier_temps+=1000;
    }

    frames+=incrementer;

    return dernier_f;
}

// Renvoie le pixel d'une surface
Uint32 GetPixel(SDL_Surface* surface, long x, long y)
{
    long bpp = surface->format->BytesPerPixel; // Octets par pixel
    /*  p est l'addresse du pixel que l'on veut rcuprer */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp)
    {
    case 1:
        return *p;

    case 2:
        return *(Uint16 *)p;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;

    case 4:
        return *(Uint32 *)p;

    default:
        return 0;  /* Ne devrait pas arriver, mais supprime les avertissements du compilateur */
    }
}

SDL_Rect obtenir_curseur_minimap(t_interface* interface,t_map *map)
{
    double ratio;

    SDL_Rect curseur;
    if(map->largeur < map->hauteur)
    {
        ratio = 160.0 / map->hauteur;
        curseur.x = (160.0 - map->largeur * ratio) / 2;
        curseur.y = 0;
    }
    else
    {
        ratio = 160.0 / map->largeur;
        curseur.x = 0;
        curseur.y = (160.0 - map->hauteur * ratio) / 2;
    }

    curseur.w = ((interface->gui[0]->crop.w+8) * ratio + TILE_TAILLE - 1) / TILE_TAILLE;
    curseur.h = (interface->gui[0]->crop.h * ratio + TILE_TAILLE - 1) / TILE_TAILLE;

    if (curseur.w > 160){curseur.w=160;}
    if (curseur.h > 160){curseur.h=160;}

    return curseur;
}

long comparer_commande(char *cmd, char *str)
{
    long i; //Compteur pour la boucle

    if(strlen(cmd) > strlen(str)) {return 0;} //Si la commande est plus longue que la saisie alors ce n'est pas cette commande qui est appele
    else
    {
        //Pour chaque caractre de la commande
        i = 0;
        while(cmd[i] != 0)
        {
            if(cmd[i] != str[i]) {return 0;} //S'il diffre de la saisie alors ce n'est pas cette commande qui est appele
            else i++;
        }
        return 1; //Si tous les caractres sont identiques, on a trouv la commande appele
    }
}
